#!/usr/bin/perl 

#
# BlueLava v0.4.3
# (c) 2001-2004  Ian Wilkinson (ian@sgtwilko.f9.co.uk)
# (c) 1999  Bruce Locke  (blocke@shivan.org)
#
# Released under the GPL v2... see COPYING for details
# This software comes without any warranty...
#


BEGIN {
# includes
require "loadconfig.pl";
require "htmlgen.pl";
require "device.pl";
}

use CGI qw(param);


load_configuration();
htmlgen_init();
#save_Configuration();

$action = param("action");
$device = param("device");
$message = param("message");
$room = param("room");
$admin = param("admin");

if ( (defined ($admin)) )
{
	require "admin.pl";
	require "saveconfig.pl";
	html_admin_page();
}
elsif ( (! defined ($action)) )
{
	generate_status_page($message);

}
else
{

	#####################################################################
	if ( ($action eq "on") || ($action eq "off") || ($action eq "bright") || ($action eq "dim") )
	{
		if ( !defined ($device) )
		{
		  html_errormsg ("Device Not Specified",
		  "<p>Action <i>$action</i> was requested without specifying a 
	 	  device id.</p>");
		  exit();
		}

		if ( $action eq "on" )
		{
	        	$result = device_on($device);
		}
		elsif ( $action eq "off" )
		{
			$result = device_off($device);
		}
		elsif ( $action eq "bright" )
		{
			$result = device_bright($device);
		}
		elsif ( $action eq "dim" )
		{
		 	$result = device_dim($device);
		}

	}	
	#####################################################################
	elsif ( ($action eq "lon") || ($action eq "loff") || ($action eq "aon") || ($action eq "aoff") )
	{
		if ( !defined ($room) )
		{
		  html_errormsg ("Room Not Specified",
		  "<p>Action <i>$action</i> was requested without specifying
		  a room.</p>");
		  exit();
		}

		if ($action eq "lon")
		{
			$result = device_room_action($room, "lamp", "on");
		}
		elsif ($action eq "loff")
		{
			$result = device_room_action($room, "lamp", "off");
		}
		elsif ($action eq "aon")
		{
			$result = device_room_action($room, "all", "on");
		}
		elsif ($action eq "aoff")
		{
			$result = device_room_action($room, "all", "off");
		}


	}
	#####################################################################
	else
	{
		html_errormsg ("Unknown Action Specified",
		"<p>Unknown action <i>$action</i> was specified.  Valid actions are
		<i>on</i>, <i>off</i>, <i>aon</i>, <i>aoff</i>, <i>lon</i>,
		<i>loff</i>, <i>bright</i>, and <i>dim</i>. </p>" );
		exit();
	}


	#####################################################################
	if ( !$result )
	{
		if (($action eq "lon") || ($action eq "loff") || ($action eq "aon") || ($action eq "aoff"))
		{
			html_bluelava_redirect("?message=Action+$action+was+performed");
		}
		else
		{
			html_bluelava_redirect("?message=Action+$action+was+performed+on+$device") ;
		}
	}
	else
	{
		html_bluelava_redirect("?message=Error+code+$result+was+returned!");
	}	


}

